<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Survey;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SurveyController extends Controller
{

    public function show(Request $request, $survey): JsonResponse
    {
        try {

            $survey = Survey::with('questions.questionOptions')->find($survey);

            if (is_null($survey)) {
                throw new \Exception('Survey not found.');
            }

            return response()->json([
                'error' => false,
                'data' => $survey,
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => false,
                'data' => $e->getMessage(),
            ]);
        }

    }
}
