<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Repositories\Shared\Infrastructure\Services\Role\RoleRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class RoleController extends Controller
{
    private RoleRepository $roleRepository;   

    public function __construct(RoleRepository $roleRepository)
    {
        $this->roleRepository = $roleRepository;
    }

    public function index($limit = 10): JsonResponse
    {
        try {
            return response()->json([
                'error' => false,
                'data' => $this->roleRepository->paginate($limit, ['id', 'name']),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function allRoles(): JsonResponse
    {
        try {

            return response()->json([
                'error' => false,
                'data' => $this->roleRepository->getAll(),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

}
