<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Shared\Infrastructure\Services\Occupation\OccupationRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class OccupationController extends Controller
{
    private OccupationRepository $occupationRepository;   

    public function __construct(OccupationRepository $occupationRepository)
    {
        $this->occupationRepository = $occupationRepository;
    }

    public function getAll(): JsonResponse
    {
        try {

            return response()->json([
                'error' => false,
                'data' => $this->occupationRepository->getAll(),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
