<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Shared\Infrastructure\Services\HearAboutUs\HearAboutUsRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class HearAboutUsController extends Controller
{
    private HearAboutUsRepository $hearAboutUsRepository;   

    public function __construct(HearAboutUsRepository $hearAboutUsRepository)
    {
        $this->hearAboutUsRepository = $hearAboutUsRepository;
    }

    public function getAll(): JsonResponse
    {
        try {

            return response()->json([
                'error' => false,
                'data' => $this->hearAboutUsRepository->getAll(),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
