<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Http\Requests\GeneralHealth\GenerateGeneralHealthRequest;
use App\Http\Requests\GeneralHealth\StoreGeneralHealthRequest;
use App\Repositories\GeneralHealth\GeneralHealthRepository;
use App\Models\Evaluation;
use App\Models\EvaluationSurvey;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class GeneralHealthController extends Controller
{

    private GeneralHealthRepository $generalHealthRepository;

    public function __construct(GeneralHealthRepository $generalHealthRepository)
    {
        $this->generalHealthRepository = $generalHealthRepository;
    }

    public function index(Request $request, $limit = 10): JsonResponse
    {
        $filter = $request->all();

        try {
            return response()->json([
                'error' => false,
                'data' => $this->generalHealthRepository->paginate($limit, $filter),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function generate(GenerateGeneralHealthRequest $request): JsonResponse
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->generalHealthRepository->generate($data),
            ],
                Response::HTTP_CREATED
            );

        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()]);
        }
    }

    public function store(StoreGeneralHealthRequest $request): JsonResponse
    { 
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->generalHealthRepository->store($data),
            ],
                Response::HTTP_CREATED
            );

        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()]);

        }
    }

    public function show($evaluationSurveyId): JsonResponse
    {
        try {

            return response()->json([
                'error' => false,
                'data' => $this->generalHealthRepository->getById($evaluationSurveyId),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }

    }

}
