<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use App\Http\Requests\FacialCare\GenerateFacialCareRequest;
use App\Http\Requests\BustCare\StoreBustCareRequest;
use App\Repositories\EvaluationSurvey\EvaluationSurveyRepository;
use App\Models\Evaluation;
use App\Models\EvaluationSurvey;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Enums\SurveyName;
use App\Http\Requests\BustCare\GenerateBustCareRequest;

class BustCareController extends Controller
{
    

    private EvaluationSurveyRepository $evaluationSurveyRepository;
    private $required_questions = [54,55,56];

    public function __construct(EvaluationSurveyRepository $evaluationSurveyRepository)
    {
        $this->evaluationSurveyRepository = $evaluationSurveyRepository;
        $this->evaluationSurveyRepository->survey = SurveyName::BUST_CARE;
        $this->evaluationSurveyRepository->required_questions = $this->required_questions;
    }

    public function index(Request $request, $limit = 10): JsonResponse
    {
        $filter = $request->all();

        try {
            return response()->json([
                'error' => false,
                'data' => $this->evaluationSurveyRepository->paginate($limit, $filter),
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function generate(GenerateBustCareRequest $request): JsonResponse
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->evaluationSurveyRepository->generate($data),
            ],
                Response::HTTP_CREATED
            );

        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()]);
        }
    }

    public function store(StoreBustCareRequest $request): JsonResponse
    { 
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->evaluationSurveyRepository->store($data),
            ],
                Response::HTTP_CREATED
            );

        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()]);

        }
    }

    public function show($evaluationSurveyId): JsonResponse
    {
        try {

            return response()->json([
                'error' => false,
                'data' => $this->evaluationSurveyRepository->getById($evaluationSurveyId),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }

    }

}
