<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Appointment\StoreAppointmentRequest;
use App\Http\Requests\Appointment\UpdateAppointmentRequest;
use App\Http\Requests\Appointment\AvailableAppointmentRequest;
use App\Http\Requests\Appointment\DeleteAppointmentRequest;
use App\Repositories\Appointment\AppointmentRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;

class AppointmentController extends Controller
{
    private AppointmentRepository $appointmentRepository;

    public function __construct(AppointmentRepository $appointmentRepository)
    {
        $this->appointmentRepository = $appointmentRepository;
    }

    public function index(Request $request, $limit = 10)
    {

        try {

            $filter = $request->all();
            if (!Auth::user()->hasRole('admin') && !Auth::user()->hasRole('estetisista')) {
                $filter['client_id'] = Auth::id();
            }

            return response()->json([
                'error' => false,
                'data' => $this->appointmentRepository->paginate($limit, $filter),],
                Response::HTTP_OK,[],
             JSON_PRESERVE_ZERO_FRACTION
            );

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAppointmentRequest $request)
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->appointmentRepository->create($data),
            ],
                Response::HTTP_CREATED
            );

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAppointmentRequest $request, string $id): JsonResponse
    {
        try {
            $data = $request->validated();

            return response()->json([
                'error' => false,
                'data' => $this->appointmentRepository->update($id, $data),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);

        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeleteAppointmentRequest $request): JsonResponse
    {
        $data = $request->validated();

        try {
            $this->appointmentRepository->delete($request->id);

            return response()->json(null, Response::HTTP_NO_CONTENT);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function appointmentAvailable(AvailableAppointmentRequest $request): JsonResponse
    {
        try {
            
            $data = $this->appointmentRepository->appointmentAvailable($request->all());

            return response()->json(['times' => (array) $data],
                Response::HTTP_OK, [],
                JSON_OBJECT_AS_ARRAY
            );

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
